import React from 'react'
import Header from '../components/Header'
import Banner from '../assets/banner.jpg'
import { Users, Target, Award, BookOpen, Brain, Globe, Heart, Zap, Eye, ArrowRight, CheckCircle } from 'lucide-react'
import Footer from '../components/Footer'
import image from '../assets/image2.jpg'

function About() {
  const stats = [
    { number: '50K+', label: 'Students Helped', icon: Users },
    { number: '15K+', label: 'Practice Questions', icon: BookOpen },
    { number: '95%', label: 'Success Rate', icon: Award },
    { number: '200+', label: 'Medical Schools', icon: Globe }
  ]

  const values = [
    {
      icon: Heart,
      title: 'Student-Centered',
      description: 'Every feature we build is designed with medical students\' success in mind, ensuring you have the best tools to excel in your studies.',
      color: 'from-rose-500 to-pink-600'
    },
    {
      icon: Brain,
      title: 'AI-Powered Learning',
      description: 'Our advanced AI technology personalizes your learning experience, adapting to your strengths and helping you overcome challenges.',
      color: 'from-violet-500 to-purple-600'
    },
    {
      icon: Target,
      title: 'Results-Driven',
      description: 'We measure success by your success. Our platform is proven to improve exam performance and knowledge retention.',
      color: 'from-emerald-500 to-green-600'
    },
    {
      icon: Zap,
      title: 'Innovation First',
      description: 'We continuously evolve our platform with cutting-edge technology to provide the most effective medical education tools.',
      color: 'from-amber-500 to-orange-600'
    }
  ]

  const features = [
    { 
      icon: BookOpen, 
      title: 'Comprehensive Question Banks', 
      description: 'Access thousands of high-quality MCQs covering all medical specialties, updated regularly by medical experts.',
      highlights: ['15,000+ Questions', 'Expert Curated', 'Regular Updates']
    },
    { 
      icon: Brain, 
      title: 'AI-Powered Tutoring', 
      description: 'Get personalized explanations and study recommendations based on your performance and learning patterns.',
      highlights: ['Personalized Learning', 'Smart Recommendations', 'Adaptive Technology']
    },
    { 
      icon: Award, 
      title: 'Progress Tracking', 
      description: 'Monitor your improvement with detailed analytics and performance insights across all subjects.',
      highlights: ['Detailed Analytics', 'Performance Insights', 'Goal Tracking']
    }
  ]

  const milestones = [
    { year: '2025', title: 'Foundation', description: 'Platform launched with first 1,000 questions' },
    { year: '2025', title: 'AI Integration', description: 'Introduced personalized learning algorithms' },
    { year: '2025', title: 'Global Expansion', description: 'Reached 100+ medical schools worldwide' },
    { year: '2025', title: 'Innovation Leader', description: 'Serving 50,000+ students with 95% success rate' }
  ]

  return (
    <div className="bg-white">
      <Header />
      
      
      <section className="relative h-[30rem] lg:h-[28rem] overflow-hidden">
        <div className="absolute inset-0">
          <img 
            src={Banner} 
            alt="Medical Education Banner"
            className="w-full h-full object-cover scale-105 transition-transform duration-700 hover:scale-110" 
          />
          <div className="absolute inset-0 bg-gradient-to-br from-slate-900/85 via-blue-900/80 to-indigo-900/85"></div>
        </div>
        
        <div className="absolute inset-0 flex items-center justify-center">
          <div className="text-center text-white max-w-5xl px-4 pt-20">
            <div className="mb-6">
              <span className="inline-block px-4 py-2 bg-white/10 backdrop-blur-sm rounded-full text-sm font-medium border border-white/20">
                Home → About Us
              </span>
            </div>
            <h1 className="text-5xl md:text-7xl font-extrabold mb-8 tracking-tight bg-gradient-to-r from-white via-blue-100 to-cyan-100 bg-clip-text text-transparent">
              About MedArchieve
            </h1>
            <p className="text-xl md:text-2xl mb-8 leading-relaxed text-blue-100 max-w-3xl mx-auto">
              Empowering the next generation of medical professionals through innovative AI-driven education
            </p>
            <div className="flex justify-center">
              <div className="w-24 h-1 bg-gradient-to-r from-cyan-400 to-blue-500 rounded-full"></div>
            </div>
          </div>
        </div>

        {/* Enhanced Floating Elements */}
        <div className="absolute inset-0 overflow-hidden pointer-events-none">
          {[...Array(12)].map((_, i) => (
            <div
              key={i}
              className="absolute animate-float"
              style={{
                left: `${Math.random() * 100}%`,
                top: `${Math.random() * 100}%`,
                animationDelay: `${Math.random() * 5}s`,
                animationDuration: `${4 + Math.random() * 3}s`
              }}
            >
              <div className="w-2 h-2 bg-cyan-400/30 rounded-full blur-sm"></div>
            </div>
          ))}
        </div>
      </section>

      
      <section className="py-20 bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 relative overflow-hidden">
        <div className="absolute inset-0 bg-grid-pattern opacity-5"></div>
        <div className="max-w-7xl mx-auto px-4 relative">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Trusted by Medical Students Worldwide
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Our platform has helped thousands of students achieve their medical education goals
            </p>
          </div>
          <div className="grid grid-cols-2 lg:grid-cols-4 gap-8">
            {stats.map((stat, index) => {
              const Icon = stat.icon
              return (
                <div key={index} className="text-center group">
                  <div className="relative">
                    <div className="w-20 h-20 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-all duration-300 shadow-lg group-hover:shadow-xl">
                      <Icon className="w-10 h-10 text-white" />
                    </div>
                    <div className="absolute -inset-4 bg-gradient-to-r from-blue-600/20 to-indigo-600/20 rounded-3xl opacity-0 group-hover:opacity-100 transition-opacity duration-300 blur-xl"></div>
                  </div>
                  <div className="text-4xl md:text-5xl font-bold text-gray-900 mb-2 bg-gradient-to-r from-blue-700 to-indigo-700 bg-clip-text text-transparent">
                    {stat.number}
                  </div>
                  <div className="text-gray-600 font-semibold text-lg">{stat.label}</div>
                </div>
              )
            })}
          </div>
        </div>
      </section>

      {/* Our Story Section with Strategic Image Placement */}
      <section className="py-24 bg-white">
        <div className="max-w-7xl mx-auto px-4">
          <div className="grid grid-cols-1 xl:grid-cols-2 gap-16 items-center">
            {/* Content Side */}
            <div className="space-y-8">
              <div>
                <span className="inline-block px-4 py-2 bg-gradient-to-r from-blue-100 to-indigo-100 text-blue-700 text-sm font-semibold rounded-full mb-6">
                  Our Story
                </span>
                <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6 leading-tight">
                  Revolutionizing Medical Education Through 
                  <span className="bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent"> Technology</span>
                </h2>
              </div>
              
              <div className="space-y-6 text-lg text-gray-700 leading-relaxed">
                <p className="text-xl text-gray-800 font-medium">
                  Founded by a team of medical professionals and education technology experts, our platform was born from a simple observation: medical students needed better, more personalized ways to prepare for their exams.
                </p>
                <p>
                  We witnessed students struggling with outdated study methods, spending countless hours on ineffective preparation, and lacking the personalized guidance they needed to excel. That's when we decided to combine cutting-edge AI technology with proven medical education principles.
                </p>
                <p>
                  Today, we're proud to serve thousands of medical students worldwide, partnering with leading medical schools to provide the most comprehensive and effective study platform available.
                </p>
              </div>

              {/* Journey Milestones */}
              <div className="space-y-4">
                <h3 className="text-2xl font-bold text-gray-900 mb-6">Our Journey</h3>
                {milestones.map((milestone, index) => (
                  <div key={index} className="flex items-start space-x-4 p-4 bg-gradient-to-r from-slate-50 to-blue-50 rounded-xl border border-blue-100">
                    <div className="flex-shrink-0 w-16 h-16 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-lg flex items-center justify-center">
                      <span className="text-white font-bold text-sm">{milestone.year}</span>
                    </div>
                    <div>
                      <h4 className="font-bold text-gray-900 mb-1">{milestone.title}</h4>
                      <p className="text-gray-600 text-sm">{milestone.description}</p>
                    </div>
                  </div>
                ))}
              </div>
            </div>
            
            {/* Image Side with Enhanced Design */}
            <div className="relative">
              <div className="relative group">
                {/* Main Image Container */}
                <div className="relative overflow-hidden rounded-3xl shadow-2xl group-hover:shadow-3xl transition-all duration-500">
                  <img 
                    src={image} 
                    alt="Medical Education Innovation"
                    className='w-full h-[600px] object-cover group-hover:scale-105 transition-transform duration-700' 
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-blue-900/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                </div>
                
                {/* Decorative Elements */}
                <div className="absolute -top-6 -right-0 w-24 h-24 bg-gradient-to-br from-cyan-400 to-blue-500 rounded-full opacity-80 blur-xl animate-pulse"></div>
                <div className="absolute -bottom-8 -left-8 w-32 h-32 bg-gradient-to-br from-indigo-400 to-purple-500 rounded-full opacity-60 blur-2xl animate-pulse" style={{animationDelay: '1s'}}></div>
                
                {/* Floating Stats Card */}
                <div className="absolute -bottom-8 -right-0 lg:right-8 bg-white p-6 rounded-2xl shadow-xl border border-gray-100 group-hover:scale-105 transition-transform duration-300">
                  <div className="text-center">
                    <div className="text-3xl font-bold text-blue-600 mb-2">4.9/5</div>
                    <div className="text-sm text-gray-600 font-medium">Student Rating</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Values Section with Enhanced Cards */}
      <section className="py-24 bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50">
        <div className="max-w-7xl mx-auto px-4">
          <div className="text-center mb-20">
            <span className="inline-block px-4 py-2 bg-gradient-to-r from-blue-100 to-indigo-100 text-blue-700 text-sm font-semibold rounded-full mb-6">
              Our Values
            </span>
            <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
              What Drives Us Forward
            </h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
              Our core values guide every decision we make and every feature we build, ensuring we always put student success first.
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            {values.map((value, index) => {
              const Icon = value.icon
              return (
                <div key={index} className="group relative">
                  <div className="bg-white p-8 rounded-3xl shadow-sm hover:shadow-xl transition-all duration-500 border border-gray-100 group-hover:border-blue-200 h-full">
                    <div className={`w-16 h-16 bg-gradient-to-r ${value.color} rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}>
                      <Icon className="w-8 h-8 text-white" />
                    </div>
                    <h3 className="text-2xl font-bold text-gray-900 mb-4 group-hover:text-blue-700 transition-colors duration-300">
                      {value.title}
                    </h3>
                    <p className="text-gray-700 leading-relaxed text-lg">{value.description}</p>
                    
                    {/* Hover Arrow */}
                    <div className="mt-6 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                      <ArrowRight className="w-5 h-5 text-blue-600" />
                    </div>
                  </div>
                  
                  {/* Gradient Border Effect */}
                  <div className={`absolute inset-0 bg-gradient-to-r ${value.color} rounded-3xl opacity-0 group-hover:opacity-10 transition-opacity duration-300 -z-10`}></div>
                </div>
              )
            })}
          </div>
        </div>
      </section>

     {/* Alternative Light Platform Features Design */}
<section className="py-24  relative overflow-hidden">
  {/* Background Decorations */}
  <div className="absolute top-0 left-0 w-96 h-96 bg-gradient-to-br from-blue-200/30 to-indigo-300/30 rounded-full blur-3xl -translate-x-1/2 -translate-y-1/2"></div>
  <div className="absolute bottom-0 right-0 w-96 h-96 bg-gradient-to-br from-purple-200/30 to-pink-300/30 rounded-full blur-3xl translate-x-1/2 translate-y-1/2"></div>
  
  {/* Floating Geometric Shapes */}
  <div className="absolute top-20 right-20 w-4 h-4 bg-blue-400/20 rotate-45 animate-pulse"></div>
  <div className="absolute top-40 left-20 w-6 h-6 bg-purple-400/20 rounded-full animate-bounce" style={{animationDelay: '1s'}}></div>
  <div className="absolute bottom-40 left-1/4 w-3 h-3 bg-indigo-400/20 rotate-45 animate-pulse" style={{animationDelay: '2s'}}></div>

  <div className="max-w-7xl mx-auto px-4 relative z-10">
    {/* Header */}
    <div className="text-center mb-20">
      <div className="inline-flex items-center space-x-2 bg-white/70 backdrop-blur-sm border border-blue-200/50 rounded-full px-6 py-3 mb-8 shadow-sm">
        <div className="w-2 h-2 bg-blue-500 rounded-full animate-pulse"></div>
        <span className="text-blue-700 font-semibold text-sm tracking-wide uppercase">
          Platform Features
        </span>
      </div>
      <h2 className="text-4xl md:text-6xl font-bold mb-8 bg-gradient-to-r from-gray-900 via-blue-800 to-indigo-800 bg-clip-text text-transparent leading-tight">
        Everything You Need<br />to Excel
      </h2>
      <p className="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
        Discover innovative features designed specifically for medical students to achieve academic excellence
      </p>
    </div>

    {/* Features Layout - Staggered Cards */}
    <div className="space-y-16">
      {features.map((feature, index) => {
        const Icon = feature.icon
        const isEven = index % 2 === 0
        const colors = [
          { bg: 'from-blue-500 to-cyan-500', accent: 'bg-blue-100', border: 'border-blue-200' },
          { bg: 'from-purple-500 to-violet-500', accent: 'bg-purple-100', border: 'border-purple-200' },
          { bg: 'from-emerald-500 to-teal-500', accent: 'bg-emerald-100', border: 'border-emerald-200' }
        ]
        const colorScheme = colors[index]
        
        return (
          <div key={index} className={`grid grid-cols-1 lg:grid-cols-12 gap-8 items-center ${!isEven ? 'lg:text-right' : ''}`}>
            {/* Content Side */}
            <div className={`lg:col-span-7 ${!isEven ? 'lg:order-2' : ''} space-y-6`}>
              <div className={`inline-flex items-center space-x-3 ${!isEven ? 'lg:justify-end' : ''}`}>
                <div className="relative">
                  <div className={`w-16 h-16 bg-gradient-to-br ${colorScheme.bg} rounded-2xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform duration-300`}>
                    <Icon className="w-8 h-8 text-white" />
                  </div>
                  <div className={`absolute -inset-2 bg-gradient-to-br ${colorScheme.bg} rounded-2xl opacity-20 blur-lg animate-pulse`}></div>
                </div>
                <div className={`px-4 py-2 ${colorScheme.accent} rounded-full ${colorScheme.border} border`}>
                  <span className="text-sm font-semibold text-gray-700">Feature {index + 1}</span>
                </div>
              </div>

              <h3 className="text-3xl md:text-4xl font-bold text-gray-900 leading-tight">
                {feature.title}
              </h3>
              
              <p className="text-lg text-gray-600 leading-relaxed max-w-2xl">
                {feature.description}
              </p>

              {/* Feature Highlights in Pills */}
              <div className={`flex flex-wrap gap-3 ${!isEven ? 'lg:justify-end' : ''}`}>
                {feature.highlights.map((highlight, idx) => (
                  <div key={idx} className={`inline-flex items-center space-x-2 px-4 py-2 bg-white rounded-full shadow-sm border ${colorScheme.border} group/pill hover:shadow-md transition-all duration-300`}>
                    <CheckCircle className={`w-4 h-4 text-${colorScheme.bg.split('-')[1]}-500 group-hover/pill:scale-110 transition-transform duration-300`} />
                    <span className="text-gray-700 font-medium text-sm">{highlight}</span>
                  </div>
                ))}
              </div>

              {/* CTA Button */}
              <div className={`pt-4 ${!isEven ? 'lg:flex lg:justify-end' : ''}`}>
                <button className={`inline-flex items-center space-x-2 px-6 py-3 bg-gradient-to-r ${colorScheme.bg} text-white rounded-xl font-semibold shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300 group/btn`}>
                  <span>Explore Feature</span>
                  <ArrowRight className="w-4 h-4 group-hover/btn:translate-x-1 transition-transform duration-300" />
                </button>
              </div>
            </div>

            {/* Visual Side */}
            <div className={`lg:col-span-5 ${!isEven ? 'lg:order-1' : ''}`}>
              <div className="relative group">
                {/* Main Card */}
                <div className={`bg-white rounded-3xl p-8 shadow-xl border-2 ${colorScheme.border} group-hover:shadow-2xl group-hover:-translate-y-2 transition-all duration-500`}>
                  {/* Card Header */}
                  <div className="flex items-center justify-between mb-6">
                    <div className={`w-12 h-12 bg-gradient-to-br ${colorScheme.bg} rounded-xl flex items-center justify-center`}>
                      <Icon className="w-6 h-6 text-white" />
                    </div>
                    <div className={`px-3 py-1 ${colorScheme.accent} rounded-full text-xs font-semibold text-gray-700`}>
                      Premium
                    </div>
                  </div>

                  {/* Mock Interface */}
                  <div className="space-y-4">
                    <div className="space-y-2">
                      <div className="h-3 bg-gray-200 rounded-full"></div>
                      <div className="h-3 bg-gray-100 rounded-full w-4/5"></div>
                      <div className="h-3 bg-gray-100 rounded-full w-3/5"></div>
                    </div>
                    
                    {/* Progress Bars */}
                    <div className="space-y-3 pt-4">
                      {[85, 92, 78].map((width, idx) => (
                        <div key={idx} className="space-y-1">
                          <div className="flex justify-between text-xs text-gray-500">
                            <span>Progress {idx + 1}</span>
                            <span>{width}%</span>
                          </div>
                          <div className="h-2 bg-gray-100 rounded-full overflow-hidden">
                            <div 
                              className={`h-full bg-gradient-to-r ${colorScheme.bg} rounded-full transition-all duration-1000 group-hover:w-full`}
                              style={{ width: `${width}%` }}
                            ></div>
                          </div>
                        </div>
                      ))}
                    </div>

                    {/* Stats */}
                    <div className="grid grid-cols-3 gap-4 pt-6 border-t border-gray-100">
                      {['2.4k', '89%', '4.9'].map((stat, idx) => (
                        <div key={idx} className="text-center">
                          <div className="text-xl font-bold text-gray-900">{stat}</div>
                          <div className="text-xs text-gray-500">Metric</div>
                        </div>
                      ))}
                    </div>
                  </div>
                </div>

                {/* Floating Elements */}
                <div className={`absolute -top-4 -right-0 w-8 h-8 bg-gradient-to-br ${colorScheme.bg} rounded-full flex items-center justify-center shadow-lg animate-bounce`} style={{animationDelay: `${index * 0.5}s`}}>
                  <span className="text-white text-xs font-bold">{index + 1}</span>
                </div>
                
                {/* Glow Effect */}
                <div className={`absolute inset-0 bg-gradient-to-br ${colorScheme.bg} opacity-5 rounded-3xl group-hover:opacity-10 transition-opacity duration-500 -z-10`}></div>
              </div>
            </div>
          </div>
        )
      })}
    </div>

    {/* Bottom Section */}
    <div className="mt-24 text-center">
      <div className="bg-white/70 backdrop-blur-sm border border-gray-200 rounded-3xl p-8 shadow-xl max-w-4xl mx-auto">
        <div className="flex flex-col md:flex-row items-center justify-between space-y-6 md:space-y-0">
          <div className="text-left">
            <h3 className="text-2xl font-bold text-gray-900 mb-2">Ready to Transform Your Studies?</h3>
            <p className="text-gray-600">Join over 50,000 medical students who trust our platform</p>
          </div>
          
          <div className="flex items-center space-x-4">
            {/* User Avatars */}
            <div className="flex -space-x-3">
              {[...Array(4)].map((_, i) => (
                <div key={i} className={`w-10 h-10 rounded-full border-2 border-white flex items-center justify-center text-white text-sm font-bold ${
                  i === 0 ? 'bg-gradient-to-br from-blue-500 to-cyan-500' :
                  i === 1 ? 'bg-gradient-to-br from-purple-500 to-violet-500' :
                  i === 2 ? 'bg-gradient-to-br from-emerald-500 to-teal-500' :
                  'bg-gradient-to-br from-orange-500 to-red-500'
                }`}>
                  {['A', 'B', 'C', '+'][i]}
                </div>
              ))}
            </div>
            
            <button className="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-8 py-3 rounded-xl font-semibold shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300">
              Get Started Free
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

      <Footer />

      <style jsx>{`
        @keyframes float {
          0%, 100% { transform: translateY(0px) rotate(0deg); }
          50% { transform: translateY(-20px) rotate(180deg); }
        }
        .animate-float {
          animation: float 6s ease-in-out infinite;
        }
        .bg-grid-pattern {
          background-image: radial-gradient(circle, #94a3b8 1px, transparent 1px);
          background-size: 20px 20px;
        }
      `}</style>
    </div>
  )
}

export default About