import React, { useState, useEffect } from 'react';

import axios from 'axios';
import { User,RefreshCw ,HelpCircle , ChevronLeft ,ChevronRight ,Award, Tags ,Building ,BarChart , FileText  , Play , AlertCircle , Upload, BookOpen, Search, Menu, X, Filter, School, Target, Check , ChevronDown , Sparkles , Eye, Plus, Brain, Clock, CheckCircle, XCircle } from 'lucide-react';
import Quiz from './Quiz';
import ViewQuestions from './ViewQuestions';
import UploadQuestion from './UploadQuestion';
import Profile from './Profile';
import Main from './Index';
import QuestionGenerator from './QuestionGenerator';
const MedicalStudentDashboard = () => {
  const [activeTab, setActiveTab] = useState('dashboard');
  const [sidebarOpen, setSidebarOpen] = useState(false);
  const [searchQuery, setSearchQuery] = useState('');
  const [selectedSubject, setSelectedSubject] = useState('all');
  const [selectedDifficulty, setSelectedDifficulty] = useState('all');
  const [selectedSchool, setSelectedSchool] = useState('all');
  
  // Quiz states
  const [quizSettings, setQuizSettings] = useState({
    subject: '',
    difficulty: 'all',
    questionCount: 5
  });
  const [currentQuiz, setCurrentQuiz] = useState(null);
  const [currentQuestionIndex, setCurrentQuestionIndex] = useState(0);
  const [userAnswers, setUserAnswers] = useState([]);
  const [showAnswer, setShowAnswer] = useState(false);
  const [quizCompleted, setQuizCompleted] = useState(false);
  const [quizResults, setQuizResults] = useState(null);

  // Nigerian Medical Schools
  const nigerianMedicalSchools = [
    "University of Ibadan",
    "University of Lagos",
    "Ahmadu Bello University",
    "University of Nigeria, Nsukka",
    "Obafemi Awolowo University",
    "University of Benin",
    "University of Calabar",
    "University of Ilorin",
    "University of Jos",
    "University of Maiduguri",
    "Bayero University, Kano",
    "University of Port Harcourt",
    "Delta State University",
    "Ebonyi State University",
    "Imo State University",
    "Lagos State University",
    "Olabisi Onabanjo University",
    "Ambrose Alli University",
    "Nnamdi Azikiwe University",
    "Abia State University"
  ];

  // Mock data
  const [questions, setQuestions] = useState([
    {
      id: 1,
      question: "What is the normal range for blood pressure?",
      answer: "Normal blood pressure is typically 120/80 mmHg or lower.",
      subject: "Cardiology",
      difficulty: "Easy",
      uploadedBy: "Adebayo Ogundimu",
      school: "University of Lagos",
      uploadedAt: "2024-01-15"
    },
    {
      id: 2,
      question: "Describe the pathophysiology of myocardial infarction",
      answer: "Myocardial infarction occurs when blood flow to the heart muscle is blocked...",
      subject: "Cardiology",
      difficulty: "Hard",
      uploadedBy: "Fatima Abdullahi",
      school: "Ahmadu Bello University",
      uploadedAt: "2024-01-14"
    },
    {
      id: 3,
      question: "What are the signs and symptoms of pneumonia?",
      answer: "Common signs include fever, cough with phlegm, chest pain, and difficulty breathing.",
      subject: "Pulmonology",
      difficulty: "Medium",
      uploadedBy: "Chinedu Okoro",
      school: "University of Nigeria, Nsukka",
      uploadedAt: "2024-01-13"
    },
    {
      id: 4,
      question: "What is the Glasgow Coma Scale?",
      answer: "The Glasgow Coma Scale is a neurological scale used to assess the level of consciousness...",
      subject: "Neurology",
      difficulty: "Medium",
      uploadedBy: "Amina Hassan",
      school: "University of Ibadan",
      uploadedAt: "2024-01-12"
    },
    {
      id: 5,
      question: "Explain the mechanism of action of ACE inhibitors",
      answer: "ACE inhibitors work by blocking the angiotensin-converting enzyme...",
      subject: "Cardiology",
      difficulty: "Hard",
      uploadedBy: "Emeka Nwankwo",
      school: "Obafemi Awolowo University",
      uploadedAt: "2024-01-11"
    }
  ]);

  const [newQuestion, setNewQuestion] = useState({
    question: '',
    answer: '',
    subject: '',
    difficulty: 'Easy',
    school: ''
  });

  const [userProfile, setUserProfile] = useState({
    name: "John Doe",
    email: "john.doe@medschool.edu",
    year: "3rd Year",
    university: "University of Lagos",
    questionsUploaded: 5,
    questionsAnswered: 23
  });

  const subjects = ['Cardiology', 'Pulmonology', 'Neurology', 'Gastroenterology', 'Endocrinology'];
  const difficulties = ['Easy', 'Medium', 'Hard'];

  const filteredQuestions = questions.filter(q => {
    const matchesSearch = q.question.toLowerCase().includes(searchQuery.toLowerCase()) ||
                         q.subject.toLowerCase().includes(searchQuery.toLowerCase()) ||
                         q.uploadedBy.toLowerCase().includes(searchQuery.toLowerCase()) ||
                         q.school.toLowerCase().includes(searchQuery.toLowerCase());
    const matchesSubject = selectedSubject === 'all' || q.subject === selectedSubject;
    const matchesDifficulty = selectedDifficulty === 'all' || q.difficulty === selectedDifficulty;
    const matchesSchool = selectedSchool === 'all' || q.school === selectedSchool;
    return matchesSearch && matchesSubject && matchesDifficulty && matchesSchool;
  });

  const handleUploadQuestion = () => {
    if (newQuestion.question && newQuestion.answer && newQuestion.subject && newQuestion.school) {
      const question = {
        id: questions.length + 1,
        ...newQuestion,
        uploadedBy: userProfile.name,
        school: newQuestion.school,
        uploadedAt: new Date().toISOString().split('T')[0]
      };
      setQuestions([...questions, question]);
      setNewQuestion({ question: '', answer: '', subject: '', difficulty: 'Easy', school: '' });
      setUserProfile(prev => ({ ...prev, questionsUploaded: prev.questionsUploaded + 1 }));
    }
  };

  // Quiz functions
  const generateQuiz = () => {
    let availableQuestions = questions;
    
    // Filter by subject
    if (quizSettings.subject !== 'all') {
      availableQuestions = availableQuestions.filter(q => q.subject === quizSettings.subject);
    }
    
    // Filter by difficulty
    if (quizSettings.difficulty !== 'all') {
      availableQuestions = availableQuestions.filter(q => q.difficulty === quizSettings.difficulty);
    }
    
    // Shuffle and select questions
    const shuffled = availableQuestions.sort(() => 0.5 - Math.random());
    const selectedQuestions = shuffled.slice(0, Math.min(quizSettings.questionCount, shuffled.length));
    
    if (selectedQuestions.length === 0) {
      alert('No questions available for the selected criteria');
      return;
    }
    
    setCurrentQuiz(selectedQuestions);
    setCurrentQuestionIndex(0);
    setUserAnswers([]);
    setShowAnswer(false);
    setQuizCompleted(false);
    setQuizResults(null);
  };

  const handleQuizAnswer = (answer) => {
    const newAnswers = [...userAnswers];
    newAnswers[currentQuestionIndex] = answer;
    setUserAnswers(newAnswers);
  };

  const nextQuestion = () => {
    setShowAnswer(false);
    if (currentQuestionIndex < currentQuiz.length - 1) {
      setCurrentQuestionIndex(currentQuestionIndex + 1);
    } else {
      completeQuiz();
    }
  };

  const completeQuiz = () => {
    const results = {
      totalQuestions: currentQuiz.length,
      answeredQuestions: userAnswers.filter(answer => answer && answer.trim() !== '').length,
      score: calculateScore(),
      answers: userAnswers,
      questions: currentQuiz
    };
    setQuizResults(results);
    setQuizCompleted(true);
  };

  const calculateScore = () => {
    // Simple scoring based on answered questions
    const answered = userAnswers.filter(answer => answer && answer.trim() !== '').length;
    return Math.round((answered / currentQuiz.length) * 100);
  };

  const resetQuiz = () => {
    setCurrentQuiz(null);
    setCurrentQuestionIndex(0);
    setUserAnswers([]);
    setShowAnswer(false);
    setQuizCompleted(false);
    setQuizResults(null);
  };

  const Sidebar = () => (
    <div className={`fixed inset-y-0 left-0 z-50 w-64 bg-blue-900 text-white transform ${sidebarOpen ? 'translate-x-0' : '-translate-x-full'} transition-transform duration-300 ease-in-out lg:translate-x-0 lg:static lg:inset-0`}>
      <div className="flex items-center justify-between p-4 border-b border-blue-800">
        <h2 className="text-xl font-bold">MedStudent</h2>
        <button onClick={() => setSidebarOpen(false)} className="lg:hidden">
          <X size={24} />
        </button>
      </div>
      <nav className="mt-8">
        <NavItem icon={<BookOpen size={20} />} label="Dashboard" tabKey="dashboard" />
        <NavItem icon={<User size={20} />} label="Profile" tabKey="profile" />
        <NavItem icon={<Upload size={20} />} label="Upload Question" tabKey="upload" />
        <NavItem icon={<Eye size={20} />} label="View Questions" tabKey="questions" />
        <NavItem icon={<Brain size={20} />} label="Quiz" tabKey="quiz" />
        <NavItem icon={<Brain size={20} />} label="Quiz Generator" tabKey="generator" />
      </nav>
    </div>
  );

  const NavItem = ({ icon, label, tabKey }) => (
    <button
      onClick={() => { setActiveTab(tabKey); setSidebarOpen(false); }}
      className={`w-full flex items-center space-x-3 px-6 py-3 text-left hover:bg-blue-800 transition-colors ${activeTab === tabKey ? 'bg-blue-800 border-r-4 border-blue-400' : ''}`}
    >
      {icon}
      <span>{label}</span>
    </button>
  );

  // const Dashboard = () => (
  //   <div className="space-y-6">
  //     <h1 className="text-3xl font-bold text-gray-800">Dashboard</h1>
  //     <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
  //       <StatsCard title="Total Questions" value={questions.length} color="bg-blue-500" />
  //       <StatsCard title="Questions Uploaded" value={userProfile.questionsUploaded} color="bg-green-500" />
  //       <StatsCard title="Questions Answered" value={userProfile.questionsAnswered} color="bg-purple-500" />
  //       <StatsCard title="Subjects Covered" value={subjects.length} color="bg-orange-500" />
  //     </div>
  //     <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
  //       <div className="bg-white p-6 rounded-lg shadow-md">
  //         <h3 className="text-lg font-semibold mb-4">Recent Questions</h3>
  //         <div className="space-y-3">
  //           {questions.slice(0, 3).map(q => (
  //             <div key={q.id} className="border-l-4 border-blue-400 pl-4 py-2">
  //               <p className="font-medium text-sm">{q.question}</p>
  //               <p className="text-xs text-gray-500">{q.subject} • {q.difficulty}</p>
  //             </div>
  //           ))}
  //         </div>
  //       </div>
  //       <div className="bg-white p-6 rounded-lg shadow-md">
  //         <h3 className="text-lg font-semibold mb-4">Subject Distribution</h3>
  //         <div className="space-y-2">
  //           {subjects.map(subject => {
  //             const count = questions.filter(q => q.subject === subject).length;
  //             return (
  //               <div key={subject} className="flex justify-between items-center">
  //                 <span className="text-sm">{subject}</span>
  //                 <span className="text-sm font-medium">{count}</span>
  //               </div>
  //             );
  //           })}
  //         </div>
  //       </div>
  //     </div>
  //   </div>
  // );

  const StatsCard = ({ title, value, color }) => (
    <div className="bg-white p-6 rounded-lg shadow-md">
      <div className="flex items-center">
        <div className={`${color} p-3 rounded-full mr-4`}>
          <BookOpen className="text-white" size={24} />
        </div>
        <div>
          <p className="text-sm text-gray-600">{title}</p>
          <p className="text-2xl font-bold text-gray-800">{value}</p>
        </div>
      </div>
    </div>
  );

  // const Profile = () => (
  //   <div className="space-y-6">
  //     <h1 className="text-3xl font-bold text-gray-800">Profile</h1>
  //     <div className="bg-white p-6 rounded-lg shadow-md">
  //       <div className="flex items-center space-x-4 mb-6">
  //         <div className="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center">
  //           <User className="text-white" size={32} />
  //         </div>
  //         <div>
  //           <h2 className="text-xl font-semibold">{userProfile.name}</h2>
  //           <p className="text-gray-600">{userProfile.year} • {userProfile.university}</p>
  //         </div>
  //       </div>
  //       <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
  //         <div>
  //           <label className="block text-sm font-medium text-gray-700 mb-2">Email</label>
  //           <input
  //             type="email"
  //             value={userProfile.email}
  //             className="w-full p-2 border border-gray-300 rounded-md"
  //             readOnly
  //           />
  //         </div>
  //         <div>
  //           <label className="block text-sm font-medium text-gray-700 mb-2">Year</label>
  //           <input
  //             type="text"
  //             value={userProfile.year}
  //             className="w-full p-2 border border-gray-300 rounded-md"
  //             readOnly
  //           />
  //         </div>
  //         <div>
  //           <label className="block text-sm font-medium text-gray-700 mb-2">University</label>
  //           <input
  //             type="text"
  //             value={userProfile.university}
  //             className="w-full p-2 border border-gray-300 rounded-md"
  //             readOnly
  //           />
  //         </div>
  //       </div>
  //     </div>
  //   </div>
  // );


  const renderContent = () => {
    switch (activeTab) {
      case 'dashboard':
        return <Main />;
      case 'profile':
        return <Profile />;
      case 'upload':
        return <UploadQuestion />;
      case 'questions':
        return <ViewQuestions /> ;
      case 'quiz':
        return <Quiz /> ;
        case 'generator':
          return <QuestionGenerator  /> ;
      default:
        return <Main />;
    }
  };

  return (
    <div className="flex h-screen bg-gray-100">
      <Sidebar />
      <div className="flex-1 flex flex-col overflow-hidden">
        <header className="bg-white shadow-sm border-b border-gray-200 px-4 py-4 lg:px-6">
          <div className="flex items-center justify-between">
            <button
              onClick={() => setSidebarOpen(true)}
              className="lg:hidden p-2 rounded-md hover:bg-gray-100"
            >
              <Menu size={24} />
            </button>
            <div className="flex items-center space-x-4">
              <span className="text-sm text-gray-600">Welcome back, {userProfile.name}</span>
              <div className="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                <User className="text-white" size={16} />
              </div>
            </div>
          </div>
        </header>
        <main className="flex-1 overflow-y-auto p-4 lg:p-6">
          {renderContent()}
        </main>
      </div>
    </div>
  );
};

export default MedicalStudentDashboard;