import React from 'react';

const StatsWidget = ({
  title,
  value,
  icon,
  subtitle,
  highlight = false, // e.g., for streak
}) => {
  return (
    <div
      className={`p-6 rounded-xl bg-white shadow-sm border transition-all ${
        highlight
          ? 'border-orange-300 bg-orange-50/30'
          : 'border-gray-200 hover:border-gray-300'
      }`}
    >
      <div className="flex items-start justify-between">
        <div className="flex-1">
          <p className="text-sm font-medium text-gray-600">{title}</p>
          <p
            className={`text-3xl font-bold mt-3 ${
              highlight ? 'text-orange-600' : 'text-gray-900'
            }`}
          >
            {value}
          </p>
          {subtitle && (
            <p className="text-sm text-gray-500 mt-2">{subtitle}</p>
          )}
        </div>

        <div
          className={`p-3 rounded-lg ${
            highlight
              ? 'bg-orange-100 text-orange-600'
              : 'bg-indigo-100 text-indigo-600'
          }`}
        >
          {icon}
        </div>
      </div>
    </div>
  );
};

export default StatsWidget;