import React, { useState } from 'react';
import { Stethoscope } from 'lucide-react';
function Footer() {
  const [hoveredIcon, setHoveredIcon] = useState(null);
  const [email, setEmail] = useState('');

  const handleSubscribe = () => {
    // Handle newsletter subscription
    if (email) {
      console.log('Subscribing email:', email);
      setEmail('');
    }
  };

  const socialLinks = [
    { name: 'Twitter', icon: '𝕏', href: '#', color: 'hover:text-gray-400' },
    // { name: 'Facebook', icon: '📘', href: '#', color: 'hover:text-blue-400' },
    // { name: 'Instagram', icon: '📷', href: '#', color: 'hover:text-pink-400' },
    // { name: 'LinkedIn', icon: '💼', href: '#', color: 'hover:text-blue-300' },
    // { name: 'YouTube', icon: '📺', href: '#', color: 'hover:text-red-400' }
  ];

  const footerSections = [
    {
      title: 'Platform',
      links: [
        { name: 'Practice Questions', href: '#' },
        { name: 'Study Guides', href: '#' },
        { name: 'Progress Tracking', href: '#' },
        // { name: 'Mobile App', href: '#' }
      ]
    },
    {
      title: 'Support',
      links: [
        { name: 'Help Center', href: '#' },
        { name: 'Contact Us', href: '#' },
        // { name: 'Live Chat', href: '#' },
        // { name: 'Tutorials', href: '#' }
      ]
    },
    {
      title: 'Company',
      links: [
        { name: 'About Us', href: '#' },
        { name: 'Careers', href: '#' },
        // { name: 'Press', href: '#' },
        { name: 'Partners', href: '#' }
      ]
    },
    {
      title: 'Legal',
      links: [
        { name: 'Privacy Policy', href: '#' },
        { name: 'Terms of Service', href: '#' },
        // { name: 'Cookie Policy', href: '#' },
        // { name: 'GDPR', href: '#' }
      ]
    }
  ];

  return (
    <footer className="bg-gradient-to-r from-blue-700 to-cyan-700 relative overflow-hidden">
      {/* Animated background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute -top-40 -right-40 w-80 h-80 bg-white/5 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute -bottom-40 -left-40 w-80 h-80 bg-cyan-300/5 rounded-full blur-3xl animate-pulse" style={{ animationDelay: '1s' }}></div>
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-blue-300/5 rounded-full blur-3xl animate-pulse" style={{ animationDelay: '2s' }}></div>
      </div>

      {/* Main Footer Content */}
      <div className="relative z-10 max-w-7xl mx-auto px-4 py-16">
        {/* Top Section */}
        <div className="grid grid-cols-1 lg:grid-cols-12 gap-8 mb-12">
          {/* Brand Section */}
          <div className="lg:col-span-4 space-y-6">
            <div className="flex items-center space-x-3">
              <div className="w-12 h-12 bg-gradient-to-r from-cyan-400 to-blue-400 rounded-xl flex items-center justify-center">
                <span className="text-white font-bold text-xl"><Stethoscope /></span>
              </div>
              <div>
                <h3 className="text-2xl font-bold text-white">MedArchieve</h3>
                <p className="text-blue-100 text-sm">Master Your Future</p>
              </div>
            </div>
            
            <p className="text-blue-100 text-lg leading-relaxed">
              Empowering students worldwide with comprehensive study materials, practice questions, and personalized learning experiences.
            </p>

            {/* Newsletter Signup */}
            <div className="bg-white/10 backdrop-blur-sm border border-white/20 rounded-xl p-6">
              <h4 className="text-white font-semibold text-lg mb-3">Stay Updated</h4>
              <p className="text-blue-100 text-sm mb-4">Get the latest study tips and platform updates</p>
              <div className="space-y-3">
                <input
                  type="email"
                  value={email}
                  onChange={(e) => setEmail(e.target.value)}
                  placeholder="Enter your email"
                  className="w-full px-4 py-3 bg-white/20 border border-white/30 rounded-lg text-white placeholder-blue-200 focus:outline-none focus:ring-2 focus:ring-cyan-400 focus:border-transparent transition-all duration-300"
                />
                <button
                  onClick={handleSubscribe}
                  className="w-full bg-gradient-to-r from-cyan-400 to-blue-400 text-white font-semibold py-3 px-6 rounded-lg hover:from-cyan-500 hover:to-blue-500 transform hover:scale-105 transition-all duration-300 shadow-lg"
                >
                  Subscribe
                </button>
              </div>
            </div>
          </div>

          {/* Links Sections */}
          <div className="lg:col-span-8 grid grid-cols-2 md:grid-cols-4 gap-8">
            {footerSections.map((section, index) => (
              <div key={index} className="space-y-4">
                <h4 className="text-white font-semibold text-lg">{section.title}</h4>
                <ul className="space-y-3">
                  {section.links.map((link, linkIndex) => (
                    <li key={linkIndex}>
                      <a
                        href={link.href}
                        className="text-blue-100 hover:text-white transition-colors duration-300 hover:translate-x-1 transform inline-block"
                      >
                        {link.name}
                      </a>
                    </li>
                  ))}
                </ul>
              </div>
            ))}
          </div>
        </div>

        {/* Divider */}
        <div className="border-t border-white/20 my-8"></div>

        {/* Bottom Section */}
        <div className="flex flex-col md:flex-row justify-between items-center space-y-6 md:space-y-0">
          {/* Social Links */}
          <div className="flex items-center space-x-6">
            <span className="text-blue-100 font-medium">Follow us:</span>
            <div className="flex space-x-4">
              {socialLinks.map((social, index) => (
                <a
                  key={index}
                  href={social.href}
                  className={`w-12 h-12 bg-white/10 backdrop-blur-sm border border-white/20 rounded-full flex items-center justify-center text-white hover:bg-white/20 transform hover:scale-110 transition-all duration-300 ${social.color}`}
                  onMouseEnter={() => setHoveredIcon(social.name)}
                  onMouseLeave={() => setHoveredIcon(null)}
                  title={social.name}
                >
                  <span className="text-xl">{social.icon}</span>
                </a>
              ))}
            </div>
          </div>

          {/* Copyright */}
          <div className="text-center md:text-right">
            <p className="text-blue-100 text-sm">
              © 2025 MedExamHub. All rights reserved.
            </p>
            <p className="text-blue-200 text-xs mt-1">
              Made with ❤️ for students worldwide
            </p>
          </div>
        </div>

        
       
      </div>

      {/* Floating particles */}
      <div className="absolute inset-0 overflow-hidden pointer-events-none">
        {[...Array(8)].map((_, i) => (
          <div
            key={i}
            className="absolute w-1 h-1 bg-white/30 rounded-full animate-pulse"
            style={{
              left: `${Math.random() * 100}%`,
              top: `${Math.random() * 100}%`,
              animationDelay: `${Math.random() * 3}s`,
              animationDuration: `${2 + Math.random() * 2}s`
            }}
          ></div>
        ))}
      </div>

      {/* Bottom gradient overlay */}
      <div className="absolute bottom-0 left-0 right-0 h-1 bg-gradient-to-r from-cyan-400 via-blue-400 to-cyan-400"></div>
    </footer>
  );
}

export default Footer;