// src/App.jsx
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import Header from './components/Header';
import Hero from './components/Hero';
import Features from './components/Features';
import Testimonials from './components/Testimonial';
import FAQ from './components/Faq';
import Footer from './components/Footer';
import AuthPage from './components/AuthPage';
import MedicalStudentDashboard from './components/dashboard/Dashboard';

// Import dashboard pages
import Main from './components/dashboard/Index';
import Profile from './components/dashboard/Profile';
import ViewQuestions from './components/dashboard/ViewQuestions';
import Quiz from './components/dashboard/Quiz';
import QuestionGenerator from './components/dashboard/QuestionGenerator';
import Courses from './components/dashboard/Courses';
import Paystack from './components/dashboard/Paystack';
import QuestionsLibrary from './components/dashboard/QuestionsLibrary';
import AdminDashboard from './components/dashboard/AdminDashboard';
import SuperAdminDashboard from './components/dashboard/SuperAdminDashboard';
import About from './pages/About';
import Service from './pages/Service';
import Contact from './pages/Contact';
import PublicQuiz from './components/dashboard/PublicQuiz';
import ManageSubject from './components/dashboard/admin/ManageSubject';
import FlashcardHub from './components/dashboard/flashcard/FlashcardHub';
import FlashcardStudySession from './components/dashboard/flashcard/FlashcardStudySession';

import { PremiumProvider } from './context/premiumContext';
import { ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

function App() {
  return (
    <>
      <Router>
        <Routes>
          {/* Public Routes */}
          <Route
            path="/"
            element={
              <>
                <Header />
                <Hero />
                <Features />
                <Testimonials />
                <FAQ />
                <Footer />
              </>
            }
          />

          <Route path="/register" element={<AuthPage />} />
          <Route path="/about" element={<About />} />
          <Route path="/contact" element={<Contact />} />
          <Route path="/services" element={<Service />} />

          {/* Protected Dashboard - Wrapped in PremiumProvider */}
          <Route
            path="/dashboard"
            element={
              <PremiumProvider>
                <MedicalStudentDashboard />
              </PremiumProvider>
            }
          >
            {/* Default dashboard page */}
            <Route index element={<Main />} />

            {/* Free for all users */}
            <Route path="profile" element={<Profile />} />
            <Route path="premium" element={<Paystack />} />

            {/* Premium-only routes */}
            <Route path="questions" element={<ViewQuestions />} />
            <Route path="quiz" element={<Quiz />} />
            <Route path="generator" element={<QuestionGenerator />} />
            <Route path="library" element={<QuestionsLibrary />} />
            <Route path="courses" element={<Courses />} />
            <Route path="public-quiz" element={<PublicQuiz />} />

            {/* Flashcards - Premium */}
            <Route path="flashcards" element={<FlashcardHub />} />
            <Route path="flashcards/study/:deckType" element={<FlashcardStudySession />} />
            <Route path="flashcards/study/course/:courseId/flashcard" element={<FlashcardStudySession />} />

            {/* Admin Routes (role-based, not premium) */}
            <Route path="admin" element={<AdminDashboard />} />
            <Route path="superadmin" element={<SuperAdminDashboard />} />
            <Route path="manage-subjects" element={<ManageSubject />} />
          </Route>

          {/* 404 */}
          <Route path="*" element={<div className="p-10 text-center text-2xl">Page Not Found</div>} />
        </Routes>
      </Router>

      <ToastContainer position="top-right" />
    </>
  );
}

export default App;