<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('session_id')->unique();
            $table->unsignedBigInteger('user_id');
            $table->json('questions_data'); // Stores question IDs and correct answers
            $table->json('user_answers')->nullable(); // Stores user's submitted answers
            $table->integer('total_questions');
            $table->integer('time_limit'); // in minutes
            $table->enum('status', ['active', 'completed', 'expired'])->default('active');
            $table->decimal('score', 5, 2)->nullable(); // percentage score
            $table->integer('correct_answers')->nullable();
            $table->timestamp('started_at');
            // $table->timestamp('expires_at');
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->index(['user_id', 'status']);
            $table->index('session_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_sessions');
    }
};