<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Subjects;
use App\Models\Questions;
class Subtopics extends Model
{
    //
    protected $table = 'sub_topics';
    protected $fillable = [
        'name'
    ];
    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    /**
     * Get the questions associated with the subtopic.
     *
     * @return HasMany
     */
    public function questions()
    {
        return $this->hasMany(Question::class, 'subtopic_id');
    }
}
