<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Subjects;
use App\Models\Subtopics;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class SubjectController extends Controller
{
    //
     // Create new subject
     public function store(Request $request)
     {
         $validator = Validator::make($request->all(), [
             'name' => 'required|string|max:255|unique:subjects',
             'description' => 'nullable|string',
             'auto_generate' => 'boolean'
         ]);
 
         if ($validator->fails()) {
             return response()->json([
                 'errors' => $validator->errors()
             ], 422);
         }
 
         $subject = Subjects::create([
             'name' => $request->name,
             'description' => $request->description,
             'auto_generate' => $request->auto_generate ?? true,
         ]);
 
         return response()->json([
             'message' => 'Subject created successfully',
             'subject' => $subject
         ], 201);
     }
 
     // Update subject
     public function update(Request $request, $id)
     {
         $subject = Subjects::findOrFail($id);
 
         $validator = Validator::make($request->all(), [
             'name' => 'required|string|max:255|unique:subjects,name,' . $id,
             'description' => 'nullable|string',
             'auto_generate' => 'boolean'
         ]);
 
         if ($validator->fails()) {
             return response()->json([
                 'errors' => $validator->errors()
             ], 422);
         }
 
         $subject->update([
             'name' => $request->name,
             'description' => $request->description,
             'auto_generate' => $request->auto_generate ?? $subject->auto_generate,
         ]);
 
         return response()->json([
             'message' => 'Subject updated successfully',
             'subject' => $subject
         ]);
     }
 
     // Delete subject
     public function destroy($id)
     {
         $subject = Subjects::findOrFail($id);
         
         // Delete all associated subtopics
         $subject->subtopics()->delete();
         
         $subject->delete();
 
         return response()->json([
             'message' => 'Subject deleted successfully'
         ]);
     }
     // Create subtopic for a subject
    public function storeSubtopic(Request $request, $subjectId)
    {
        $subject = Subjects::findOrFail($subjectId);

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors()
            ], 422);
        }

        $subtopic = $subject->subtopics()->create([
            'name' => $request->name,
            'description' => $request->description,
        ]);

        return response()->json([
            'message' => 'Subtopic created successfully',
            'subtopic' => $subtopic
        ], 201);
    }
    // Toggle auto-generate setting
    public function toggleAutoGenerate(Request $request, $id)
    {
       
        $subject = Subjects::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'auto' => 'required|boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors()
            ], 422);
        }
        if($request->auto == true){
            $subject->update([
                'auto' => 1
            ]);
        }else{
            $subject->update([
                'auto' => 0
            ]);
        }
       

        return response()->json([
            'message' => 'Auto-generate setting updated',
            'subject' => $subject
        ]);
    }
}
